/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import mekanism.common.Mekanism;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;

public class BaseModelCache {
    private final Map<ResourceLocation, ModelData> modelMap = new Object2ObjectOpenHashMap();

    public void onBake(ModelBakeEvent evt) {
        this.modelMap.values().forEach(m -> m.reload(evt));
    }

    public void setup() {
        this.modelMap.values().forEach(ModelData::setup);
    }

    protected OBJModelData registerOBJ(ResourceLocation rl) {
        return this.register(rl, OBJModelData::new);
    }

    protected JSONModelData registerJSON(ResourceLocation rl) {
        return this.register(rl, JSONModelData::new);
    }

    protected <DATA extends ModelData> DATA register(ResourceLocation rl, Function<ResourceLocation, DATA> creator) {
        ModelData data = (ModelData)creator.apply(rl);
        this.modelMap.put(rl, data);
        return (DATA)data;
    }

    public static BakedModel getBakedModel(ModelBakeEvent evt, ResourceLocation rl) {
        BakedModel bakedModel = (BakedModel)evt.getModelRegistry().get(rl);
        if (bakedModel == null) {
            Mekanism.logger.error("Baked model doesn't exist: {}", (Object)rl.toString());
            return evt.getModelManager().m_119409_();
        }
        return bakedModel;
    }

    public static class ModelData {
        protected IModelGeometry<?> model;
        protected final ResourceLocation rl;
        private final Map<IModelConfiguration, BakedModel> bakedMap = new Object2ObjectOpenHashMap();

        protected ModelData(ResourceLocation rl) {
            this.rl = rl;
        }

        protected void reload(ModelBakeEvent evt) {
            this.bakedMap.clear();
        }

        protected void setup() {
        }

        public BakedModel bake(IModelConfiguration config) {
            return this.bakedMap.computeIfAbsent(config, c -> this.model.bake(c, (ModelBakery)ForgeModelBakery.instance(), ForgeModelBakery.defaultTextureGetter(), (ModelState)BlockModelRotation.X0_Y0, ItemOverrides.f_111734_, this.rl));
        }

        public IModelGeometry<?> getModel() {
            return this.model;
        }
    }

    public static class OBJModelData
    extends ModelData {
        protected OBJModelData(ResourceLocation rl) {
            super(rl);
        }

        @Override
        protected void reload(ModelBakeEvent evt) {
            super.reload(evt);
            this.model = OBJLoader.INSTANCE.loadModel(new OBJModel.ModelSettings(this.rl, true, this.useDiffuseLighting(), true, true, null));
        }

        public OBJModel getModel() {
            return (OBJModel)super.getModel();
        }

        protected boolean useDiffuseLighting() {
            return true;
        }
    }

    public static class JSONModelData
    extends ModelData {
        private BakedModel bakedModel;

        private JSONModelData(ResourceLocation rl) {
            super(rl);
        }

        @Override
        protected void reload(ModelBakeEvent evt) {
            super.reload(evt);
            this.bakedModel = BaseModelCache.getBakedModel(evt, this.rl);
            UnbakedModel unbaked = evt.getModelLoader().m_119341_(this.rl);
            if (unbaked instanceof BlockModel) {
                BlockModel blockModel = (BlockModel)unbaked;
                this.model = blockModel.customData.getCustomGeometry();
            }
        }

        @Override
        protected void setup() {
            ForgeModelBakery.addSpecialModel((ResourceLocation)this.rl);
        }

        public BakedModel getBakedModel() {
            return this.bakedModel;
        }
    }
}

